package ibase.communication.whatsApp;

import java.util.HashMap;

public class ChatDataManager {
    private static HashMap<String, HashMap<String, Object>> chatDataMap = new HashMap<>();
    
    static synchronized HashMap<String, Object> getChatData(String chatId) {
        // Retrieve chat-specific data from HashMap
        return chatDataMap.computeIfAbsent(chatId, k -> new HashMap<>());
    }

    static synchronized void removeChatData(String chatId) {
        // Remove chat-specific data from HashMap after processing
        chatDataMap.remove(chatId);
    }

}
